/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.pa.persist;

import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.service.persist.GenericPersistence;
import com.ibm.hwmca.fw.service.persist.impl.GenericPersistenceImpl;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEvent;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventPersistence;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventPersistenceException;
import com.ibm.hwmca.fw.service.serviceaction.ServiceAction;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class DefaultProblemPersistence
implements ServiceableEventPersistence,
Comparator {
    private static final String TRACE_MASKT = "XPADPERT";
    private static final String TRACE_MASKF = "XPADPERF";
    private static final String TRACE_MASKD = "XPADPERD";
    private static String parentKey = new String("com.ibm.hwmca.fw.pa.persist");
    private GenericPersistence problemPersistence;
    private GenericPersistence repairPersistence;
    private static final int _maxProblemCount = 200;
    private static final int _purgeDelta = 20;
    private static int _currentNumberChanged = 0;
    private static int _numberLoaded = 0;

    public DefaultProblemPersistence() {
        Trace.trace(TRACE_MASKT, "--> DefaultProblemPersistence (ctor)");
        this.problemPersistence = new GenericPersistenceImpl(parentKey);
        this.repairPersistence = new GenericPersistenceImpl(parentKey + ".repair");
        Trace.trace(TRACE_MASKT, "<-- DefaultProblemPersistence (ctor)");
    }

    public void store(ServiceableEvent problem) throws ServiceableEventPersistenceException {
        Trace.trace(TRACE_MASKT, "--> DefaultProblemPersistence.store(problem[" + problem + "])");
        try {
            if (problem.hasServiceAction()) {
                Trace.trace(TRACE_MASKD, "storing repair for problem " + problem.getUniqueKey());
                ServiceAction repair = problem.getServiceAction();
                this.repairPersistence.store(problem.getUniqueKey(), repair);
            } else {
                try {
                    this.repairPersistence.remove(problem.getUniqueKey());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (((Problem)problem).getProblemNumber() == Integer.MIN_VALUE & ((Problem)problem).getProblemState() == 1) {
                this.createLog();
            }
            this.problemPersistence.store(problem.getUniqueKey(), problem);
            Trace.trace(TRACE_MASKD, "the _currentNumberChanged is :" + ++_currentNumberChanged);
            Trace.trace(TRACE_MASKD, "the _numberLoaded         is :" + ++_numberLoaded);
            if (_currentNumberChanged > 20 && _numberLoaded > 200) {
                Trace.trace(TRACE_MASKF, "need to do a purge v1.0 5.5.04");
                try {
                    Trace.trace(TRACE_MASKF, "hit the refresh");
                    ProblemManager pm = ProblemManager.getProblemManager();
                    List problemList = pm.getAllProblems();
                    _currentNumberChanged = 0;
                    this.purgeProblems(problemList, true);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "got a PM exception");
                    Trace.trace(TRACE_MASKF, e);
                }
            }
        }
        catch (PersistenceException pe) {
            Trace.trace(TRACE_MASKT, "exception");
            Trace.trace(TRACE_MASKT, pe);
            Trace.trace(TRACE_MASKT, "<-- DefaultProblemPersistence.store()");
            throw new ServiceableEventPersistenceException(pe);
        }
        Trace.trace(TRACE_MASKT, "<-- DefaultProblemPersistence.store(problem[" + problem + "])");
    }

    public void store(List problems) throws ServiceableEventPersistenceException {
        Trace.trace(TRACE_MASKT, "-> DefaultProblemPersistence.store(List)");
        Iterator iterator = problems.iterator();
        while (iterator.hasNext()) {
            Problem problem = (Problem)iterator.next();
            try {
                Trace.trace(TRACE_MASKD, "storing problem " + problem.getUniqueKey());
                if (problem.hasServiceAction()) {
                    Trace.trace(TRACE_MASKD, "storing repair for problem " + problem.getUniqueKey());
                    ServiceAction repair = problem.getServiceAction();
                    this.repairPersistence.store(problem.getUniqueKey(), repair);
                } else {
                    try {
                        this.repairPersistence.remove(problem.getUniqueKey());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (problem.getProblemNumber() == Integer.MIN_VALUE & problem.getProblemState() == 1) {
                    this.createLog();
                }
                this.problemPersistence.store(problem.getUniqueKey(), problem);
            }
            catch (PersistenceException pe) {
                Trace.trace(TRACE_MASKF, "Got a persistence exception");
                Trace.trace(TRACE_MASKF, pe);
                Trace.trace(TRACE_MASKT, "<-- DefaultProblemPersistence.store()");
                throw new ServiceableEventPersistenceException(pe);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- DefaultProblemPersistence.store()");
    }

    public void remove(List problems) throws ServiceableEventPersistenceException {
        Trace.trace(TRACE_MASKT, "--> DefaultProblemPersistence.remove(List); list size[" + problems.size() + "]");
        try {
            Iterator it = problems.iterator();
            while (it.hasNext()) {
                Problem problem = (Problem)it.next();
                String id = problem.getUniqueKey();
                Trace.trace(TRACE_MASKT, "removing problem " + id);
                this.problemPersistence.remove(id);
                try {
                    this.repairPersistence.remove(id);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (PersistenceException pe) {
            Trace.trace(TRACE_MASKF, "Got a persistence exception");
            Trace.trace(TRACE_MASKF, pe);
            Trace.trace(TRACE_MASKT, "<-- DefaultProblemPersistence.remove(List);");
            throw new ServiceableEventPersistenceException(pe);
        }
        Trace.trace(TRACE_MASKT, "<-- DefaultProblemPersistence.remove(List); list size[" + problems.size() + "]");
    }

    public void remove(ServiceableEvent problem) throws ServiceableEventPersistenceException {
        Trace.trace(TRACE_MASKT, "--> DefaultProblemPersistence.remove(); problem[" + problem + "]");
        try {
            String id = problem.getUniqueKey();
            Trace.trace(TRACE_MASKT, "removing problem " + id);
            this.problemPersistence.remove(id);
            try {
                this.repairPersistence.remove(id);
            }
            catch (Exception e) {}
        }
        catch (PersistenceException pe) {
            Trace.trace(TRACE_MASKF, "Got a persistence exception");
            Trace.trace(TRACE_MASKF, pe);
            Trace.trace(TRACE_MASKT, "<-- DefaultProblemPersistence.remove;");
            throw new ServiceableEventPersistenceException(pe);
        }
        Trace.trace(TRACE_MASKT, "<-- DefaultProblemPersistence.remove");
    }

    public ServiceableEvent load(String key) throws ServiceableEventPersistenceException {
        Trace.trace(TRACE_MASKT, "-> DefaultProblemPersistence.load(key[" + key + "]) 5.5.04");
        Problem problem = null;
        try {
            problem = (Problem)this.problemPersistence.load(key);
            if (problem.hasServiceAction()) {
                problem.setServiceAction((ServiceAction)this.repairPersistence.load(key));
            }
            Trace.trace(TRACE_MASKD, "number of loaded problems is " + ++_numberLoaded);
        }
        catch (PersistenceException pe) {
            Trace.trace(TRACE_MASKF, "Got a persistence exception");
            Trace.trace(TRACE_MASKF, pe);
            Trace.trace(TRACE_MASKT, "<-- DefaultProblemPersistence.load()");
            throw new ServiceableEventPersistenceException(pe);
        }
        Trace.trace(TRACE_MASKT, "<-- DefaultProblemPersistence.load(key[" + key + "])");
        return problem;
    }

    public List load() throws ServiceableEventPersistenceException {
        Trace.trace(TRACE_MASKT, "-> DefaultProblemPersistence.load()");
        List list = null;
        try {
            list = this.problemPersistence.load();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                ServiceableEvent problem = (ServiceableEvent)it.next();
                if (!problem.hasServiceAction()) continue;
                problem.setServiceAction((ServiceAction)this.repairPersistence.load(problem.getUniqueKey()));
            }
        }
        catch (PersistenceException pe) {
            Trace.trace(TRACE_MASKF, "Got a persistence exception");
            Trace.trace(TRACE_MASKF, pe);
            Trace.trace(TRACE_MASKT, "<-- DefaultProblemPersistence.load()");
            throw new ServiceableEventPersistenceException(pe);
        }
        if (list != null) {
            int listSize = list.size();
            if (listSize > 200) {
                Trace.trace(TRACE_MASKF, "need to purge the problems >>>>");
                list = this.purgeProblems(list, false);
            }
            _numberLoaded = list.size();
            Trace.trace(TRACE_MASKT, "passing back " + _numberLoaded + " problems");
        }
        Trace.trace(TRACE_MASKT, "<-- DefaultProblemPersistence.load()");
        return list;
    }

    protected List purgeProblems(List intialProblemSet, boolean removePM) {
        List<Problem> returnList;
        block35: {
            Trace.trace(TRACE_MASKF, "--> purgeProblems v 1.0");
            int totalNumberOfProblems = intialProblemSet.size();
            Trace.trace(TRACE_MASKF, "the intialProblemSet size is " + totalNumberOfProblems);
            returnList = new ArrayList();
            ArrayList<Problem> createdProblems = new ArrayList<Problem>();
            ArrayList<Problem> openProblems = new ArrayList<Problem>();
            ArrayList<Problem> closedProblems = new ArrayList<Problem>();
            ArrayList<Problem> dupProblems = new ArrayList<Problem>();
            Iterator initialSetIterator = intialProblemSet.iterator();
            Trace.trace(TRACE_MASKD, "sort the lists");
            while (initialSetIterator.hasNext()) {
                Problem aProblem = (Problem)initialSetIterator.next();
                int status = aProblem.getProblemState();
                if (status == 1) {
                    openProblems.add(aProblem);
                    continue;
                }
                if (status == 2) {
                    closedProblems.add(aProblem);
                    continue;
                }
                if (aProblem.isDuplicateOf()) {
                    dupProblems.add(aProblem);
                    continue;
                }
                createdProblems.add(aProblem);
            }
            int openProblemCount = openProblems.size();
            int createdProblemCount = createdProblems.size();
            int closeProblemCount = closedProblems.size();
            int dupProblemCount = dupProblems.size();
            Trace.trace(TRACE_MASKF, "After the sorting, the break down is :");
            Trace.trace(TRACE_MASKF, "number of open problems is :" + openProblemCount);
            Trace.trace(TRACE_MASKF, "number of created problems is :" + createdProblemCount);
            Trace.trace(TRACE_MASKF, "number of closed problems is :" + closeProblemCount);
            Trace.trace(TRACE_MASKF, "number of dup problems is :" + dupProblemCount);
            try {
                if (totalNumberOfProblems > 200) {
                    Iterator probIt;
                    ProblemManager pm;
                    int numberToRemove = totalNumberOfProblems - 200;
                    Trace.trace(TRACE_MASKD, "the number to remove is " + numberToRemove);
                    List removedList = null;
                    if (dupProblemCount > 0) {
                        Trace.trace(TRACE_MASKD, "trim the dup list");
                        removedList = this.trimList(numberToRemove, dupProblems);
                        if (removePM) {
                            try {
                                Trace.trace(TRACE_MASKD, "removing the problems from the problem manager");
                                pm = ProblemManager.getProblemManager();
                                probIt = removedList.iterator();
                                while (probIt.hasNext()) {
                                    pm.remove((Problem)probIt.next());
                                }
                            }
                            catch (Exception e) {
                                Trace.trace(TRACE_MASKD, "got an error removing the problem");
                                Trace.trace(TRACE_MASKD, e);
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "remove the problem only from persistence manager.");
                            this.remove(removedList);
                        }
                        numberToRemove -= removedList.size();
                    }
                    if (numberToRemove > 0) {
                        if (closeProblemCount > 0) {
                            Trace.trace(TRACE_MASKD, "get rid of the closed problems");
                            removedList = this.trimList(numberToRemove, closedProblems);
                            if (removePM) {
                                try {
                                    Trace.trace(TRACE_MASKD, "removing the problems from the problem manager");
                                    pm = ProblemManager.getProblemManager();
                                    probIt = removedList.iterator();
                                    while (probIt.hasNext()) {
                                        pm.remove((Problem)probIt.next());
                                    }
                                }
                                catch (Exception e) {
                                    Trace.trace(TRACE_MASKD, "got an error removing the problem");
                                    Trace.trace(TRACE_MASKD, e);
                                }
                            } else {
                                Trace.trace(TRACE_MASKF, "remove the problem only from persistence manager.");
                                this.remove(removedList);
                            }
                            numberToRemove -= removedList.size();
                        }
                        if (numberToRemove > 0) {
                            int numberOfOpenToKeep = 0;
                            int numberOfCreatedToKeep = 0;
                            int numberToKeep = 0;
                            float openRatio = (float)openProblemCount / (float)(openProblemCount + createdProblemCount);
                            float createdRatio = (float)createdProblemCount / (float)(openProblemCount + createdProblemCount);
                            Trace.trace(TRACE_MASKD, "the open count is    : " + openProblemCount);
                            Trace.trace(TRACE_MASKD, "the created count is : " + createdProblemCount);
                            Trace.trace(TRACE_MASKD, "the total count is   : " + (openProblemCount + createdProblemCount));
                            Trace.trace(TRACE_MASKD, "the open ratio is    : " + openRatio);
                            Trace.trace(TRACE_MASKD, "the created ratio is : " + createdRatio);
                            if (numberToRemove > 200) {
                                Trace.trace(TRACE_MASKD, "split the count ");
                                numberToKeep = 200;
                            } else {
                                numberToKeep = openProblemCount + createdProblemCount - numberToRemove;
                            }
                            Trace.trace(TRACE_MASKD, "the number to keep is:" + numberToKeep);
                            numberOfOpenToKeep = (int)((float)numberToKeep * openRatio);
                            numberOfCreatedToKeep = (int)((float)numberToKeep * createdRatio);
                            Trace.trace(TRACE_MASKD, "the number of opens to keep is " + numberOfOpenToKeep);
                            Trace.trace(TRACE_MASKD, "the number of creates to keep is " + numberOfCreatedToKeep);
                            if (openProblemCount > 0) {
                                Trace.trace(TRACE_MASKD, "split the open list up");
                                removedList = this.splitList(numberOfOpenToKeep, openProblems);
                                this.remove(removedList);
                                if (removePM) {
                                    try {
                                        Trace.trace(TRACE_MASKD, "removing the problems");
                                        ProblemManager pm2 = ProblemManager.getProblemManager();
                                        Iterator probIt2 = removedList.iterator();
                                        while (probIt2.hasNext()) {
                                            pm2.remove((Problem)probIt2.next());
                                        }
                                    }
                                    catch (Exception e) {
                                        Trace.trace(TRACE_MASKD, "got an error removing the problem");
                                        Trace.trace(TRACE_MASKD, e);
                                    }
                                }
                            }
                            if (createdProblemCount > 0) {
                                Trace.trace(TRACE_MASKD, "split the created list up");
                                removedList = this.splitList(numberOfCreatedToKeep, createdProblems);
                                this.remove(removedList);
                            }
                        }
                    }
                    openProblemCount = openProblems.size();
                    createdProblemCount = createdProblems.size();
                    closeProblemCount = closedProblems.size();
                    dupProblemCount = dupProblems.size();
                    Trace.trace(TRACE_MASKF, "After the purge, the break down is :");
                    Trace.trace(TRACE_MASKF, "number of open problems is :" + openProblemCount);
                    Trace.trace(TRACE_MASKF, "number of created problems is :" + createdProblemCount);
                    Trace.trace(TRACE_MASKF, "number of closed problems is :" + closeProblemCount);
                    Trace.trace(TRACE_MASKF, "number of dup problems is :" + dupProblemCount);
                    Trace.trace(TRACE_MASKF, "rejoin the lists");
                    if (closedProblems.size() > 0) {
                        returnList.addAll(closedProblems);
                    }
                    if (dupProblems.size() > 0) {
                        returnList.addAll(dupProblems);
                    }
                    if (createdProblems.size() > 0) {
                        returnList.addAll(createdProblems);
                    }
                    if (openProblems.size() > 0) {
                        returnList.addAll(openProblems);
                    }
                    Trace.trace(TRACE_MASKD, "Done purging. Build the return list. Size is " + returnList.size());
                    break block35;
                }
                Trace.trace(TRACE_MASKF, "the number of logs is under the limit");
                returnList = intialProblemSet;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKD, "caught an exception");
                Trace.trace(TRACE_MASKD, e);
            }
        }
        Trace.trace(TRACE_MASKF, "<-- purgeProblems");
        return returnList;
    }

    public List splitList(int splitPoint, List input) {
        Trace.trace(TRACE_MASKD, "-->splitList(" + splitPoint + ")");
        ArrayList returnList = new ArrayList();
        int listSize = input.size();
        if (splitPoint < listSize) {
            Collections.sort(input, this);
            returnList.addAll(input.subList(splitPoint, listSize));
            Trace.trace(TRACE_MASKD, "before the clear input.size() is =" + input.size());
            Trace.trace(TRACE_MASKD, "split point is = " + splitPoint);
            Trace.trace(TRACE_MASKD, "listSize is = " + listSize);
            input.subList(splitPoint, listSize).clear();
            Trace.trace(TRACE_MASKD, "after the clear the size is " + input.size());
        } else {
            Trace.trace(TRACE_MASKD, "there is nothing to remove");
        }
        Trace.trace(TRACE_MASKD, "returning");
        Trace.trace(TRACE_MASKD, "splitList size is " + returnList.size());
        Trace.trace(TRACE_MASKD, "input size is " + input.size());
        Trace.trace(TRACE_MASKD, "<-- splitList");
        return returnList;
    }

    public List trimList(int numberToTrim, List input) {
        List returnList = new ArrayList();
        int inputSize = input.size();
        if (numberToTrim < inputSize) {
            returnList = this.splitList(numberToTrim, input);
        } else {
            Trace.trace(TRACE_MASKD, "remove them all");
            returnList.addAll(input);
            input.clear();
        }
        return returnList;
    }

    public int compare(Object o1, Object o2) {
        long t2;
        long t1 = ((Problem)o1).getProblemTimeStamp();
        if (t1 < (t2 = ((Problem)o2).getProblemTimeStamp())) {
            return 1;
        }
        if (t1 > t2) {
            return -1;
        }
        return 0;
    }

    private void createLog() {
        Exception ex = new Exception("Trace problem number dump exception");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ex.printStackTrace(printWriter);
        String exceptionTrace = stringWriter.toString();
        Log theLog = new Log(11, 20, -21026, "PA TRACE", null, null, null, "AA32FFFF FFFFFFFF");
        theLog.add((byte)-127, exceptionTrace);
        theLog.add((byte)3, "HOSED LOG");
        theLog.log();
    }

    public static void main(String[] args) {
        Trace.trace(TRACE_MASKD, "--> DefaultProblemPersistence.main()");
        DefaultProblemPersistence persistence = new DefaultProblemPersistence();
        List<CommonProblem> testProblemList = new ArrayList<CommonProblem>(400);
        int i = 0;
        while (i < 129) {
            CommonProblem aProblem = new CommonProblem();
            aProblem.setProblemState(1);
            testProblemList.add(aProblem);
            aProblem = new CommonProblem();
            aProblem.setProblemState(2);
            testProblemList.add(aProblem);
            aProblem = new CommonProblem();
            aProblem.setProblemState(0);
            testProblemList.add(aProblem);
            ++i;
        }
        int i2 = 0;
        while (i2 < 27) {
            CommonProblem aProblem = new CommonProblem();
            aProblem.setProblemState(0);
            testProblemList.add(aProblem);
            ++i2;
        }
        testProblemList = persistence.purgeProblems(testProblemList, true);
        System.out.println("the list is now " + testProblemList.size() + " long");
    }
}

